/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;

public final class VWSplitType {
    private static final int MIN_SPLIT_TYPE = 1;
    public static final int SPLIT_TYPE_AND = 1;
    public static final int SPLIT_TYPE_OR = 2;
    public static final int SPLIT_TYPE_NONE = 3;
    private static final int MAX_SPLIT_TYPE = 3;
    private static String[] LocalizedStrings = new String[]{new VWString("VW.api.VWSplitTypeAnd", "And").toString(), new VWString("VW.api.VWSplitTypeOr", "Or").toString(), new VWString("VW.api.VWSplitTypeNone", "None").toString()};

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-23 22:02:23 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/1 $";
    }

    public static String getLocalizedString(int theSplitType) throws VWException {
        if (!VWSplitType.isValid(theSplitType)) {
            throw new VWException("vw.api.VWSplitTypeBadInteger", "Integer form of the split type is invalid: {0}", String.valueOf(theSplitType));
        }
        return LocalizedStrings[theSplitType - 1];
    }

    public static boolean isValid(int theSplitType) {
        return theSplitType >= 1 && theSplitType <= 3;
    }

    protected static String typeToString(int splitType) throws VWException {
        switch (splitType) {
            case 1: {
                return "and";
            }
            case 2: {
                return "or";
            }
            case 3: {
                return "none";
            }
        }
        throw new VWException("vw.api.VWSplitTypeBadInteger", "Integer form of the split type is invalid: {0}", String.valueOf(splitType));
    }

    protected static int stringToType(String splitType) throws VWException {
        if (splitType.equals("and")) {
            return 1;
        }
        if (splitType.equals("or")) {
            return 2;
        }
        if (splitType.equals("none")) {
            return 3;
        }
        throw new VWException("vw.api.VWSplitTypeBadString", "String form of the split type is invalid: {0}", splitType);
    }
}

